/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entites;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ReaperEntity
extends MonsterEntity
implements IAnimatable {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final AnimationBuilder DEATH_ANIMATION = new AnimationBuilder().addAnimation("death", Boolean.valueOf(false));
    private final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true));
    private final AnimationBuilder WALK_ANIMATION = new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true));
    private final AnimationBuilder SPAWN_ANIMATION = new AnimationBuilder().addAnimation("spawn", Boolean.valueOf(false));
    private final AnimationBuilder ATTACK_ANIMATION = new AnimationBuilder().addAnimation("attack", Boolean.valueOf(true));
    protected final byte ANIMATION_IDLE = 0;
    protected final byte ANIMATION_WALK = 1;
    protected final byte ANIMATION_SPAWN = (byte)2;
    protected final byte ANIMATION_DEATH = (byte)3;
    protected final byte ANIMATION_ATTACK = (byte)4;
    protected static final DataParameter<Byte> ANIMATION = EntityDataManager.func_187226_a(ReaperEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(ReaperEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private BlockPos boundOrigin;
    MobEntity owner;
    @Nullable
    private BlockPos bounds;

    public ReaperEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS_ID, (Object)0);
        this.field_70180_af.func_187214_a(ANIMATION, (Object)0);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_74764_b("BoundX")) {
            this.boundOrigin = new BlockPos(p_70037_1_.func_74762_e("BoundX"), p_70037_1_.func_74762_e("BoundY"), p_70037_1_.func_74762_e("BoundZ"));
        }
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        if (this.boundOrigin != null) {
            p_213281_1_.func_74768_a("BoundX", this.boundOrigin.func_177958_n());
            p_213281_1_.func_74768_a("BoundY", this.boundOrigin.func_177956_o());
            p_213281_1_.func_74768_a("BoundZ", this.boundOrigin.func_177952_p());
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new ChargeAttackGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new MoveRandomGoal());
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new CopyOwnerTargetGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_213315_a(MoverType p_213315_1_, Vector3d p_213315_2_) {
        super.func_213315_a(p_213315_1_, p_213315_2_);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        this.setAnimation((byte)2);
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean isDying = this.func_233643_dh_();
        boolean isAttacking = this.func_213398_dR();
        if (isDying) {
            controller.setAnimation(this.DEATH_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (isAttacking || this.isCharging()) {
            controller.setAnimation(this.ATTACK_ANIMATION);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 4: {
                controller.setAnimation(this.ATTACK_ANIMATION);
                break;
            }
            default: {
                controller.setAnimation(isMoving ? this.WALK_ANIMATION : this.IDLE_ANIMATION);
            }
        }
        return PlayState.CONTINUE;
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos p_190651_1_) {
        this.boundOrigin = p_190651_1_;
    }

    private boolean getVexFlag(int p_190656_1_) {
        byte i = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID);
        return (i & p_190656_1_) != 0;
    }

    private void setVexFlag(int p_190660_1_, boolean p_190660_2_) {
        int i = ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID)).byteValue();
        i = p_190660_2_ ? (i |= p_190660_1_) : (i &= ~p_190660_1_);
        this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    public void setIsCharging(boolean p_190648_1_) {
        this.setVexFlag(1, p_190648_1_);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233818_a_, 20.0);
    }

    public byte getAnimation() {
        return (Byte)this.field_70180_af.func_187225_a(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.field_70180_af.func_187227_b(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void func_70642_aH() {
        this.func_184185_a(SoundEvents.field_191264_hc, 1.0f, -10.0f);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        this.func_184185_a(SoundEvents.field_191267_hf, 1.0f, -10.0f);
        return super.func_184601_bQ(p_184601_1_);
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        this.func_184185_a(SoundEvents.field_191266_he, 1.0f, -10.0f);
        return super.func_184615_bR();
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (ReaperEntity.this.func_70638_az() != null && !ReaperEntity.this.func_70605_aq().func_75640_a() && ReaperEntity.this.field_70146_Z.nextInt(7) == 0) {
                return ReaperEntity.this.func_70068_e((Entity)ReaperEntity.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return ReaperEntity.this.func_70605_aq().func_75640_a() && ReaperEntity.this.isCharging() && ReaperEntity.this.func_70638_az() != null && ReaperEntity.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            LivingEntity livingentity = ReaperEntity.this.func_70638_az();
            Vector3d vector3d = livingentity.func_174824_e(1.0f);
            ReaperEntity.this.field_70765_h.func_75642_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 1.0);
            ReaperEntity.this.setIsCharging(true);
            ReaperEntity.this.func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
        }

        public void func_75251_c() {
            ReaperEntity.this.setIsCharging(false);
        }

        public void func_75246_d() {
            LivingEntity livingentity = ReaperEntity.this.func_70638_az();
            if (ReaperEntity.this.func_174813_aQ().func_72326_a(livingentity.func_174813_aQ())) {
                ReaperEntity.this.func_70652_k((Entity)livingentity);
                ReaperEntity.this.setIsCharging(false);
            } else {
                double d0 = ReaperEntity.this.func_70068_e((Entity)livingentity);
                if (d0 < 9.0) {
                    Vector3d vector3d = livingentity.func_174824_e(1.0f);
                    ReaperEntity.this.field_70765_h.func_75642_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 1.0);
                }
            }
        }
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !ReaperEntity.this.func_70605_aq().func_75640_a() && ReaperEntity.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = ReaperEntity.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = ReaperEntity.this.func_233580_cy_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(ReaperEntity.this.field_70146_Z.nextInt(15) - 7, ReaperEntity.this.field_70146_Z.nextInt(11) - 5, ReaperEntity.this.field_70146_Z.nextInt(15) - 7);
                if (!ReaperEntity.this.field_70170_p.func_175623_d(blockpos1)) continue;
                ReaperEntity.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (ReaperEntity.this.func_70638_az() != null) break;
                ReaperEntity.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class MoveHelperController
    extends MovementController {
        public MoveHelperController(ReaperEntity p_i47230_2_) {
            super((MobEntity)p_i47230_2_);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - ReaperEntity.this.func_226277_ct_(), this.field_75647_c - ReaperEntity.this.func_226278_cu_(), this.field_75644_d - ReaperEntity.this.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (d0 < ReaperEntity.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    ReaperEntity.this.func_213317_d(ReaperEntity.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    ReaperEntity.this.func_213317_d(ReaperEntity.this.func_213322_ci().func_178787_e(vector3d.func_186678_a(this.field_75645_e * 0.05 / d0)));
                    if (ReaperEntity.this.func_70638_az() == null) {
                        Vector3d vector3d1 = ReaperEntity.this.func_213322_ci();
                        ReaperEntity.this.field_70761_aq = ReaperEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d2 = ReaperEntity.this.func_70638_az().func_226277_ct_() - ReaperEntity.this.func_226277_ct_();
                        double d1 = ReaperEntity.this.func_70638_az().func_226281_cx_() - ReaperEntity.this.func_226281_cx_();
                        ReaperEntity.this.field_70761_aq = ReaperEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d2, (double)d1)) * 57.295776f;
                    }
                }
            }
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final EntityPredicate copyOwnerTargeting;

        public CopyOwnerTargetGoal(CreatureEntity p_i47231_2_) {
            super((MobEntity)p_i47231_2_, false);
            this.copyOwnerTargeting = new EntityPredicate().func_221014_c().func_221010_e();
        }

        public boolean func_75250_a() {
            return ReaperEntity.this.owner != null && ReaperEntity.this.owner.func_70638_az() != null && this.func_220777_a(ReaperEntity.this.owner.func_70638_az(), this.copyOwnerTargeting);
        }

        public void func_75249_e() {
            ReaperEntity.this.func_70624_b(ReaperEntity.this.owner.func_70638_az());
            super.func_75249_e();
        }
    }
}

